<?
$QTY = 2;      // Количество записей на странице

require_once('config.php');
require_once('util.php');

try {
   $part = 1;

   $uri_parts = explode('/', $_SERVER['REQUEST_URI']);
   if(count($uri_parts) > 0){
      $part = $uri_parts[count($uri_parts)-1];
      if(!is_numeric($part)){
         $part = 1;
      }
   }

   require_once('DB/settings.php');
   require_once('DB/db.php');
   $db = new Database();

   $settings_qty = $db->getSettingsQty();

   $settings = $db->getSettings($part, $QTY);
?>

<style>
      body{
         font-family: Verdana;
      }
      table{
         border-spacing: 0;
      }
      th {
         width: 200px;
         padding: 10px 0 20px 0;
         border-bottom: 5px solid #daeef3;
         text-align: center;
      }
      td{
         padding: 10px 20px;
         text-align: center;
         border-bottom: 3px solid #daeef3;
      }
      .button{
         min-width: 25px;
         text-align: center;
         border: 1px solid #000;
         border-radius: 5px;
         padding: 5px;
         margin: 5px;
         float: left;
      }
      .active-button{
         background-color: #daeef3;
      }
      #paginator{
         margin-top: 30px;
      }
   </style>
   </br>
   </br>
   <p class="wb-stl-heading2" style="text-align: center;">Настройки (история изменений)</p>
   </br>
   </br>
   <table>
   <tr>
      <th>Дата</th>
      <th>Тикет</th>
      <th>Базовая Инвестиция, лот</th>
      <th>Точка Актуальности</th>
      <th>Размер рабочего лота, лот</th>
      <th>Y</th>
   </tr>
   <?
   if($settings != null){
      usort($settings, function($a, $b) {
         if ($a->Data == $b->Data){
            return 0;
         }else{
            return $a->Data < $b->Data ? 1 : -1;
         }
      });

      for($i=0;$i<count($settings);$i++){
         echo '<tr><td style="text-align: left">' 
         . $settings[$i]->Data . '</td><td>' 
         . $settings[$i]->Tiket . '</td><td>'
         . $settings[$i]->Invest . '</td><td>'
         . $settings[$i]->TA . '</td><td>'
         . $settings[$i]->Rlot . '</td><td>'
         . $settings[$i]->Y . '</td></tr>';
      }
   }
   ?>
   </table> 
   <?
      if($settings_qty > $QTY){
         echo '<div id="paginator">';
         $num = 0;
         for($i=0;$i<$settings_qty;$i+=$QTY){
            $num++;
            if($part == $num){
               echo '<a href="https://lua-script.ru/state-lua-history/' . $num . '"><div class="button active-button">' . $num . '</div></a>';
            }else{
               echo '<a href="https://lua-script.ru/state-lua-history/' . $num . '"><div class="button">' . $num . '</div></a>';
            }
         }
         echo '</div>';
      }
   ?>
   </br>
   </br>

<?
} catch (Throwable $e) {

   my_error_log($e->getMessage() . ': ' . $e->getFile() . ' #' . $e->getLine());

}