<?
// Максимальное количество выводимых сделок
$MAX_COUNT = 20;

require_once('config.php');
require_once('util.php');

try {

   $month = null;

   $uri_parts = explode('/', $_SERVER['REQUEST_URI']);
   if(count($uri_parts) > 0){
      $last_part = $uri_parts[count($uri_parts)-1];
      if(strlen($last_part) == 6 && is_numeric($last_part)){
         $month = substr($last_part, 0, 4) . '-' . substr($last_part, -2);
      }
   }

   require_once('DB/trade.php');
   require_once('DB/db.php');
   $db = new Database();

   $trades = $db->getTrades();
?>

<html>
<html lang="ru">
<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <title>Сделки MOBILE</title>
   <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
</head>
<body>
   <style>
      body{
         font-family: Verdana;
      }
      table{
         border-spacing: 0;
      }
      th {
         width: 150px;
         padding: 10px 0 10px 0;
         border-bottom: 5px solid #daeef3;
      }
      td{
         padding: 3px 0 5px 0;
         text-align: center;
         border-bottom: 3px solid #daeef3;
      }
      tr.no-border > td{
         border-bottom: 0;
      }
   </style>
   <br>
   <br>
   <table>
   <tr id="theader">
      <th style="width:200px">Дата</th>
      <th>Тикет/ Операция</th>
      <th>Цена/ Лот</th>
      <th>Сумма/ Прибыль</th>
   </tr>
   <?

   $buy_sum = 0;
   $sell_sum = 0;
   $profit_sum = 0;

   if($trades != null){
      echo '<div id="last_id" style="display:none">' . $trades[count($trades)-1]->Id . '</div>';
      if($month != null)
         echo '<div id="month" style="display:none">' . $month . '</div>';
      else
         echo '<div id="month" style="display:none"></div>';

      $count = 0;
      for($i=count($trades)-1;$i>=0;$i--){
         $count++;
         if($month != null || $count <= $MAX_COUNT){
            echo '<tr class="no-border"><td>' 
            . $trades[$i]->Data . '</td><td>' 
            . $trades[$i]->Tiket . '</td><td>'
            . number_divide_space($trades[$i]->Price) . '</td><td style="text-align: right">'
            . number_divide_space(($trades[$i]->Sum * ($trades[$i]->Operation == 'Buy' ? 1 : -1))) . '</td><td>';
            echo '<tr><td>' 
            . $trades[$i]->Time . '</td><td>'
            . $trades[$i]->Operation . '</td><td>'
            . ($trades[$i]->Lots * ($trades[$i]->Operation == 'Buy' ? 1 : -1)) . '</td><td style="text-align: right">'
            . number_divide_space(($trades[$i]->Profit > 0 ? $trades[$i]->Profit : '')) . '</td></tr>';
         
            $buy_sum += ($trades[$i]->Sum * ($trades[$i]->Operation == 'Buy' ? 1 : 0));
            $sell_sum -= ($trades[$i]->Sum * ($trades[$i]->Operation == 'Sell' ? 1 : 0));
            $profit_sum += $trades[$i]->Profit;
         }
      }
   }
   echo '<tr class="no-border"><td></td></tr>'
   .'<tr class="no-border"><td></td><td></td><td style="text-align: right">Куплено на сумму:</td><td id="buy_sum" style="text-align: right">' . number_divide_space($buy_sum) . '</td></tr>'
   .'<tr class="no-border"><td></td><td></td><td style="text-align: right">Продано на сумму:</td><td id="sell_sum" style="text-align: right">' . number_divide_space($sell_sum) . '</td></tr>'
   .'<tr class="no-border"><td></td><td></td><td style="text-align: right">Прибыль:</td><td id="profit_sum" style="text-align: right">' . number_divide_space($profit_sum) . '</td></tr>';
   ?>
   </table>
   <script>
      $(function() {

         var last_id = $('#last_id').text();
         var month = $('#month').text();
         var buy_sum = Number($('#buy_sum').text());
         var sell_sum = Number($('#sell_sum').text());
         var profit_sum = Number($('#profit_sum').text());

         setInterval(function () {
            $.ajax({
               url: '/get-new-trades.php',         /* Куда отправить запрос */
               method: 'post',             /* Метод запроса (post или get) */
               dataType: 'json',          /* Тип данных в ответе (xml, json, script, html). */
               data: {last_id: last_id, month : month},     /* Данные передаваемые в массиве */
               success: function(data){   /* функция которая будет выполнена после успешного запроса.  */
                  if(data.length > 0){
                     for (let i = data.length-1; i >= 0; i--) {
                        $('<tr><td style="text-align: left">' 
                           + data[i].Time + '</td><td>'
                           + data[i].Operation + '</td><td>'
                           + (data[i].Lots * (data[i].Operation == 'Buy' ? 1 : -1)) + '</td><td>'
                           + number_divide_space((data[i].Profit > 0 ? data[i].Profit : '')) + '</td></tr>'
                        ).insertAfter('#theader');
                        $('<tr class="no-border"><td style="text-align: left">' 
                           + data[i].Data + '</td><td>' 
                           + data[i].Tiket + '</td><td>'
                           + number_divide_space(data[i].Price) + '</td><td>'
                           + number_divide_space((data[i].Sum * (data[i].Operation == 'Buy' ? 1 : -1))) + '</td><td>'
                        ).insertAfter('#theader');

                        if(data[i].Operation == 'Buy'){
                           buy_sum += Number(data[i].Sum);
                        }else{
                           sell_sum -= Number(data[i].Sum);
                        }
                        profit_sum += Number(data[i].Profit);
                     }

                     $('#buy_sum').text(number_divide_space(buy_sum));
                     $('#sell_sum').text(number_divide_space(sell_sum));
                     $('#profit_sum').text(number_divide_space(profit_sum));
                     
                     last_id = data[data.length-1].Id                     
                  }
               }
            });
         }, 1000);
      });
   </script>
</body>
</html>

<?
} catch (Throwable $e) {

   my_error_log($e->getMessage() . ': ' . $e->getFile() . ' #' . $e->getLine());

}