<?
$QTY = 2;      // Количество записей на странице

require_once('config.php');
require_once('util.php');

try {
   $part = 1;

   $uri_parts = explode('/', $_SERVER['REQUEST_URI']);
   if (count($uri_parts) > 0) {
      $part = $uri_parts[count($uri_parts) - 1];
      if (!is_numeric($part)) {
         $part = 1;
      }
   }

   require_once('DB/money.php');
   require_once('DB/db.php');
   $db = new Database();

   $money_qty = $db->getMoneyQty();

   $money = $db->getMoney($part, $QTY);
?>

   <style>
      body {
         font-family: Verdana;
      }

      table {
         border-spacing: 0;
      }

      th {
         width: 200px;
         padding: 10px 0 20px 0;
         border-bottom: 5px solid #daeef3;
         text-align: center;
      }

      td {
         padding: 10px 20px;
         text-align: center;
         border-bottom: 3px solid #daeef3;
      }

      .button {
         min-width: 25px;
         text-align: center;
         border: 1px solid #000;
         border-radius: 5px;
         padding: 5px;
         margin: 5px;
         float: left;
      }

      .active-button {
         background-color: #daeef3;
      }

      #paginator {
         margin-top: 30px;
      }
   </style>
   </br>
   </br>
   <p class="wb-stl-heading2" style="text-align: center;">Деньги</p>
   </br>
   </br>
   <table>
      <tr>
         <th>Дата</th>
         <th>Время</th>
         <th>Сумма</th>
      </tr>
      <?
      if ($money != null) {
         usort($money, function ($a, $b) {
            if ($a->Data == $b->Data) {
               return 0;
            } else {
               return $a->Data < $b->Data ? 1 : -1;
            }
         });

         for ($i = 0; $i < count($money); $i++) {
            echo '<tr><td style="text-align: left">'
               . $money[$i]->Data . '</td><td>'
               . $money[$i]->Time . '</td><td>'
               . number_divide_space($money[$i]->Money) . '</td></tr>';
         }
      }
      ?>
   </table>
   <?
   if ($money_qty > $QTY) {
      echo '<div id="paginator">';
      $num = 0;
      for ($i = 0; $i < $money_qty; $i += $QTY) {
         $num++;
         if ($part == $num) {
            echo '<a href="https://lua-script.ru/money-history/' . $num . '"><div class="button active-button">' . $num . '</div></a>';
         } else {
            echo '<a href="https://lua-script.ru/money-history/' . $num . '"><div class="button">' . $num . '</div></a>';
         }
      }
      echo '</div>';
   }
   ?>

<?
} catch (Throwable $e) {

   my_error_log($e->getMessage() . ': ' . $e->getFile() . ' #' . $e->getLine());
}
