<?
require_once('config.php');
require_once('util.php');

try {
   require_once('DB/pos.php');
   require_once('DB/db.php');
   $db = new Database();

   $poses = $db->getPoses();
?>
   <center>
   <table>
      <tr>
         <th>Дата</th>
         <th>Время</th>
         <th>Тикет</th>
         <th>Остаток, лот</th>
         <th>В 1 лоте</th>
         <th>Цена, руб</th>
         <th>Сумма</th>
      </tr>
      <?
      if ($poses != null) {
         $last_poses = [];
         for ($i = 0; $i < count($poses); $i++) {
            if (!isset($last_poses[$poses[$i]->Tiket])) {
               $last_poses[$poses[$i]->Tiket] = $poses[$i];
            } else {
               if ($last_poses[$poses[$i]->Tiket]->Data < $poses[$i]->Data) {
                  $last_poses[$poses[$i]->Tiket] = $poses[$i];
               }
            }
         }

         $poses = [];

         foreach ($last_poses as $key => $value) {
            array_push($poses, $value);
         }

         usort($poses, function ($a, $b) {
            if ($a->Data == $b->Data) {
               return 0;
            } else {
               return $a->Data < $b->Data ? 1 : -1;
            }
         });

         for ($i = 0; $i < count($poses); $i++) {
            echo '<tr><td style="text-align: left">'
               . $poses[$i]->Data . '</td><td>'
               . $poses[$i]->Time . '</td><td>'
               . $poses[$i]->Tiket . '</td><td>'
               . $poses[$i]->LotsStart . '</td><td>'
               . number_divide_space($poses[$i]->InLots) . '</td><td>'
               . number_divide_space($poses[$i]->Price) . '</td><td>'
               . number_divide_space($poses[$i]->Summ) . '</td></tr>';
         }
      }
      ?>
   </table>
   <br />
   <a href="https://lua-script.ru/lots-day-start-history-pc/1">История изменений</a>
   </center>

<?
} catch (Throwable $e) {

   my_error_log($e->getMessage() . ': ' . $e->getFile() . ' #' . $e->getLine());
}
