Редактировать файл - instruments.php
<?
require_once('config.php');
require_once('util.php');

try {

   require_once('DB/security.php');
   require_once('DB/security-current-params.php');
   require_once('DB/db.php');
   $db = new Database();

   $uri_parts = explode('/', $_SERVER['REQUEST_URI']);
   $akcii_class_codes = ['MTQR', 'SMAL', 'TQBR'];
   $obligacii_class_codes = ['BRPMA_BND', 'BRPMG_BND', 'PSAU', 'PSBB', 'PSBB_OFZN', 'PSYO', 'PTDB', 'TQCB', 'TQOB', 'TQOY', 'TQRD'];
   $class_code = '';
   $sec_code = '';
   // Код бумаги указан
   if ($uri_parts[2] !== null && $uri_parts[2] !== ''){
      $sec_code = $uri_parts[2];
      if($uri_parts[1] == 'akcii'){
         $class_code = $db->getSecurityClassCode($sec_code, $akcii_class_codes);
      }elseif($uri_parts[1] == 'obligacii'){
         $class_code = $db->getSecurityClassCode($sec_code, $obligacii_class_codes);
      }

      // Код бумаги не указан
   }else{
      if($uri_parts[1] == 'akcii'){
         $class_code = 'TQBR';
         $sec_code = $db->getFirstSecurityByClass($class_code)->SecCode;
      }elseif($uri_parts[1] == 'obligacii'){
         $class_code = 'TQOB';
         $sec_code = $db->getFirstSecurityByClass($class_code)->SecCode;
      }
   }

   $security = $db->getSecurity($class_code, $sec_code);
   $security_current_params = $db->getSecurityCurrentParams($class_code, $sec_code);
?>

   <style>
      body {
         font-family: Verdana;
      }

      table {
         border-spacing: 0;
      }

      th {
         width: 200px;
         padding: 10px 0 20px 0;
         border-bottom: 5px solid #daeef3;
         text-align: center;
      }

      td {
         padding: 10px 20px;
         text-align: center;
         /*border-bottom: 3px solid #daeef3;*/
      }

      #params {
         margin: 30px auto 30px auto;
         width: 80%;
      }

      #instrument {
         width: 90%;
         margin-bottom: 30px;
      }
      #instrument_params {
         width: 20%;
      }
      #instrument_info {
         width: 80%;
      }

      #params {
         border: 3px solid #daeef3;
      }

      .param_name{
         border-bottom: 1px solid #daeef3;
         border-right: 1px solid #daeef3;
         text-align: left;
      }
      .param_value{
         border-bottom: 1px solid #daeef3;
         text-align: left;
      }
   </style>
   </br>
   </br>
   <h1 style="text-align: center;"><? echo $sec_code; ?> sec_code </h1>
   <?
   echo '<table id="instrument">';
      echo '<tr>';
         echo '<td id="instrument_params">';
            echo '<table id="params">';

               echo '<tr><td class="param_name">Дата/Время</td><td class="param_value">' . $security->Timestamp . '</td></tr>';
               echo '<tr><td class="param_name">Код класса</td><td class="param_value">' . $security->ClassCode . '</td></tr>';
               echo '<tr><td class="param_name">Код бумаги</td><td class="param_value">' . $security->SecCode . '</td></tr>';
               echo '<tr><td class="param_name">Тип инструмента</td><td class="param_value">' . $security->SecTypeStatic . '</td></tr>';
               echo '<tr><td class="param_name">Подтип инструмента</td><td class="param_value">' . $security->SecSubtypeStatic . '</td></tr>';
               echo '<tr><td class="param_name">Полное имя</td><td class="param_value">' . $security->SecName . '</td></tr>';
               echo '<tr><td class="param_name">Короткое имя</td><td class="param_value">' . $security->ShortName . '</td></tr>';
               echo '<tr><td class="param_name">ISIN</td><td class="param_value">' . $security->ISIN . '</td></tr>';
               echo '<tr><td class="param_name">Рег.номер</td><td class="param_value">' . $security->RegNumber . '</td></tr>';
               echo '<tr><td class="param_name">Имя класса</td><td class="param_value">' . $security->ClassName . '</td></tr>';
               echo '<tr><td class="param_name">Номинал</td><td class="param_value">' . round($security->FaceValue) . '</td></tr>';
               echo '<tr><td class="param_name">Валюта номинала</td><td class="param_value">' . $security->FaceUnit . '</td></tr>';
               echo '<tr><td class="param_name">Точность цены</td><td class="param_value">' . $security->Scale . '</td></tr>';
               echo '<tr><td class="param_name">Мин.шаг</td><td class="param_value">' . round($security->MinPriceStep, $security->Scale) . '</td></tr>';
               echo '<tr><td class="param_name">Статус</td><td class="param_value">' . $security->SecStatus . '</td></tr>';
               echo '<tr><td class="param_name">Лот</td><td class="param_value">' . $security->LotSize . '</td></tr>';
               echo '<tr><td class="param_name">Объем обращения</td><td class="param_value">' . round($security->IssueSize) . '</td></tr>';
               echo '<tr><td class="param_name">Тип цены</td><td class="param_value">' . $security->QuoteBasis . '</td></tr>';
               echo '<tr><td class="param_name">Код расчетов</td><td class="param_value">' . $security->SettleCode . '</td></tr>';
               echo '<tr><td class="param_name">Сопряженная валюта</td><td class="param_value">' . $security->CurrencyId . '</td></tr>';
               echo '<tr><td class="param_name">Объем торгов пред.дня</td><td class="param_value">' . round($security_current_params->PrevValtoday) . '</td></tr>';
               echo '<tr><td class="param_name">Цена закр.пред.дня</td><td class="param_value">' . round($security_current_params->PrevSettlePrice, $security->Scale) . '</td></tr>';
               echo '<tr><td class="param_name">Цена последней сделки</td><td class="param_value">' . round($security_current_params->Last, $security->Scale) . '</td></tr>';
               
            echo '</table>';
         echo '</td>';
         echo '<td id="instrument_info">';
         if(file_exists(dirname(__FILE__) . '/instruments/' . $security->SecCode.'.php')){
            include dirname(__FILE__) . '/instruments/' . $security->SecCode.'.php';
         }else{
            include dirname(__FILE__) . '/instruments/zaglushka.php';
         }
         echo '</td>';
      echo '</tr>';
   echo '</table>';
   ?>

<?
} catch (Throwable $e) {

   my_error_log($e->getMessage() . ': ' . $e->getFile() . ' #' . $e->getLine());
}
?>
</p>