<?
class Database
{
   public $connection;
   
   public function __construct() {
      $this->connection = mysqli_connect(DB_HOST, DB_USER_NAME, DB_PASSWORD, DB_NAME);
      if (!$this->connection) {
         die();
      }
   }

   public function addTrade($trade){

      $stmt = $this->connection
         ->prepare("INSERT INTO Sdelki(Data, Time, Operation, Tiket, Price, Lots, Sum, AM, Y, Profit) 
         VALUES (?,?,?,?,?,?,?,?,?,?)");
      
      $stmt->bind_param("ssssdidsid", 
         $trade->Data,
         $trade->Time,
         $trade->Operation,
         $trade->Tiket,
         $trade->Price,
         $trade->Lots,
         $trade->Sum,
         $trade->AM,
         $trade->Y,
         $trade->Profit
      );
      $stmt->execute();
   }

   public function getLastBuyTradeSum($tiket){
      $stmt = $this->connection->prepare('SELECT Sum FROM Sdelki WHERE Tiket=? AND Operation="Buy" ORDER BY Id DESC LIMIT 1');
      $stmt->bind_param("s", $tiket);
      $stmt->execute();
      $result = $stmt->get_result();
      if ($result->num_rows > 0){
         return $result->fetch_array()[0];
      }else{
         return null;
      }
   }

   public function addPos($pos){

      $stmt = $this->connection
         ->prepare("INSERT INTO LotsDayStart(Data, Time, Tiket, LotsStart, InLots, Price, Summ) 
         VALUES (?,?,?,?,?,?,?)");
      
      $stmt->bind_param("sssiidd", 
         $pos->Data,
         $pos->Time,
         $pos->Tiket,
         $pos->LotsStart,
         $pos->InLots,
         $pos->Price,
         $pos->Summ
      );
      $stmt->execute();
   }

   public function getPoses($part = null, $qty = null){
      $poses = [];

      $query = '';

      $rows_qty = $this->getPosesQty();

      if($part != null && $qty != null){
         $from = $rows_qty - $qty * $part;
         if($from < 0){
            $qty = $qty + $from;
            $from = 0;
         }
         $query = 'SELECT * FROM LotsDayStart ORDER BY Id LIMIT ' . $from . ', ' . $qty;
      }else{
         $query = 'SELECT * FROM LotsDayStart';
      }

      $result = $this->connection->query($query);
      if ($result->num_rows > 0){
         while ($pos = $result->fetch_object('Pos')){
            array_push($poses, $pos);
         }    
      }else{
         return null;
      }

      return $poses;
   }

   public function getPosesQty(){
      $query = 'SELECT * FROM LotsDayStart';
      $result = $this->connection->query($query);
      return $result->num_rows;
   }

   public function addMoney($money){

      $stmt = $this->connection
         ->prepare("INSERT INTO Money(Data, Time, Money) 
         VALUES (?,?,?)");
      
      $stmt->bind_param("ssd", 
         $money->Data,
         $money->Time,
         $money->Money
      );
      $stmt->execute();
   }

   public function getMoney($part = null, $qty = null){
      $money = [];

      $query = '';

      $rows_qty = $this->getMoneyQty();

      if($part != null && $qty != null){
         $from = $rows_qty - $qty * $part;
         if($from < 0){
            $qty = $qty + $from;
            $from = 0;
         }
         $query = 'SELECT * FROM Money ORDER BY Id LIMIT ' . $from . ', ' . $qty;
      }else{
         $query = 'SELECT * FROM Money';
      }

      $result = $this->connection->query($query);
      if ($result->num_rows > 0){
         while ($_money = $result->fetch_object('Money')){
            array_push($money, $_money);
         }    
      }else{
         return null;
      }

      return $money;
   }

   public function getMoneyQty(){
      $query = 'SELECT * FROM Money';
      $result = $this->connection->query($query);
      return $result->num_rows;
   }

   public function addSettings($settings){

      $stmt = $this->connection
         ->prepare("INSERT INTO Settings(Data, Time, Tiket, Invest, TA, Rlot, Y) 
         VALUES (?,?,?,?,?,?,?)");
      
      $stmt->bind_param("sssidii", 
         $settings->Data,
         $settings->Time,
         $settings->Tiket,
         $settings->Invest,
         $settings->TA,
         $settings->Rlot,
         $settings->Y,
      );
      $stmt->execute();
   }

   public function getSettings($part = null, $qty = null){
      $settings = [];

      $query = '';

      $rows_qty = $this->getSettingsQty();

      if($part != null && $qty != null){
         $from = $rows_qty - $qty * $part;
         if($from < 0){
            $qty = $qty + $from;
            $from = 0;
         }
         $query = 'SELECT * FROM Settings ORDER BY Id LIMIT ' . $from . ', ' . $qty;
      }else{
         $query = 'SELECT * FROM Settings';
      }

      $result = $this->connection->query($query);
      if ($result->num_rows > 0){
         while ($setting = $result->fetch_object('Settings')){
            array_push($settings, $setting);
         }    
      }else{
         return null;
      }

      return $settings;
   }

   public function getSettingsQty(){
      $query = 'SELECT * FROM Settings';
      $result = $this->connection->query($query);
      return $result->num_rows;
   }

   public function getTradesByMonth(){
      $trades = [];
      $query = 'SELECT * FROM Sdelki';
      $result = $this->connection->query($query);
      if ($result->num_rows > 0){
         while ($trade = $result->fetch_object('Trade')){
            array_push($trades, $trade);
         }    
      }else{
         return null;
      }

      $dates = [];
      $trades_by_month = [];

      $year_str = 0;
      $month = 0;
      $month_str = '';
      for($i = 0; $i < count($trades); $i++){
         $year_str = substr($trades[$i]->Data, 0, 4);
         $month = intval(substr($trades[$i]->Data, 5, 2));
         switch ($month) {
            case 1:
               $month_str = 'Январь';
               break;
            case 2:
               $month_str = 'Февраль';
               break;
            case 3:
               $month_str = 'Март';
               break;
            case 4:
               $month_str = 'Апрель';
               break;
            case 5:
               $month_str = 'Май';
               break;
            case 6:
               $month_str = 'Июнь';
               break;
            case 7:
               $month_str = 'Июль';
               break;
            case 8:
               $month_str = 'Август';
               break;
            case 9:
               $month_str = 'Сентябрь';
               break;
            case 10:
               $month_str = 'Октябрь';
               break;
            case 11:
               $month_str = 'Ноябрь';
               break;
            case 12:
               $month_str = 'Декабрь';
               break;
         }

         $month = strval($month);
         if(strlen($month) == 1){
            $month = '0' . $month;
         }

         if($dates[$year_str . ', ' . $month_str] == null){
            $dates[$year_str . ', ' . $month_str] = [
               'DateNum' => intval($year_str . $month),
               'Date' => $year_str . ', ' . $month_str,
               'SumBuy' => 0,
               'SumSell' => 0,
               'OpQty' => 0,
               'ProfitSum' => 0
            ];
         }

         if($trades[$i]->Operation == 'Buy'){
            $dates[$year_str . ', ' . $month_str]['SumBuy'] += $trades[$i]->Sum;
         }else{
            $dates[$year_str . ', ' . $month_str]['SumSell'] -= $trades[$i]->Sum;
         }

         $dates[$year_str . ', ' . $month_str]['OpQty'] += 1;
         $dates[$year_str . ', ' . $month_str]['ProfitSum'] += $trades[$i]->Profit;
      }

      foreach ($dates as $date => $values){
         array_push($trades_by_month, $values);
      }

      usort($trades_by_month, function($a, $b) {
         if ($a['DateNum'] == $b['DateNum']){
            return 0;
         }else{
            return $a['DateNum'] < $b['DateNum'] ? 1 : -1;
         }
      });

      return $trades_by_month;
   }

   public function addSecurity($security){

      $stmt = $this->connection
         ->prepare("INSERT INTO Securities(
            Timestamp, 
            ClassCode, 
            SecCode, 
            SecTypeStatic, 
            SecSubtypeStatic, 
            SecName, 
            ShortName, 
            ISIN, 
            RegNumber, 
            ClassName, 
            FaceValue, 
            FaceUnit, 
            Scale, 
            MinPriceStep, 
            SecStatus, 
            LotSize, 
            IssueSize, 
            QuoteBasis, 
            SettleCode, 
            CurrencyId) 
         VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
      
      $stmt->bind_param("ssssssssssdsidsiisss", 
         $security->Timestamp, 
         $security->ClassCode, 
         $security->SecCode, 
         $security->SecTypeStatic, 
         $security->SecSubtypeStatic, 
         $security->SecName, 
         $security->ShortName, 
         $security->ISIN, 
         $security->RegNumber, 
         $security->ClassName, 
         $security->FaceValue, 
         $security->FaceUnit, 
         $security->Scale, 
         $security->MinPriceStep, 
         $security->SecStatus, 
         $security->LotSize, 
         $security->IssueSize, 
         $security->QuoteBasis, 
         $security->SettleCode, 
         $security->CurrencyId
      );
      $stmt->execute();
   }
   public function getSecurityId($class_code, $sec_code){
      $stmt = $this->connection->prepare('SELECT Id FROM Securities WHERE ClassCode=? AND SecCode=?');
      $stmt->bind_param("ss", $class_code, $sec_code);
      $stmt->execute();
      $result = $stmt->get_result();
      if ($result->num_rows > 0){
         return $result->fetch_array()[0];
      }else{
         return null;
      }
   }
   public function getSecurity($class_code, $sec_code){
      $stmt = $this->connection->prepare('SELECT * FROM Securities WHERE ClassCode=? AND SecCode=? LIMIT 1');
      $stmt->bind_param("ss", $class_code, $sec_code);
      $stmt->execute();
      $result = $stmt->get_result();
      if ($result->num_rows > 0){
         return $result->fetch_object('Security');
      }else{
         return null;
      }
   }
   public function getFirstSecurityByClass($class_code){
      $stmt = $this->connection->prepare('SELECT * FROM Securities WHERE ClassCode=? LIMIT 1');
      $stmt->bind_param("s", $class_code);
      $stmt->execute();
      $result = $stmt->get_result();
      if ($result->num_rows > 0){
         return $result->fetch_object('Security');
      }else{
         return null;
      }
   }
   public function getSecuritiesByClassCodes($class_codes){
      $query = 'SELECT DISTINCT SecCode FROM Securities WHERE';
      if(count($class_codes) == 1){
         $query .=  ' ClassCode="' . $class_codes[0] . '"';
      }else{
         for($i=0;$i<count($class_codes);$i++){
            if($i == 0){
               $query .= ' ClassCode="' . $class_codes[$i] . '"';
            }else{
               $query .= ' OR ClassCode="' . $class_codes[$i] . '"';
            }            
         }
      }
      $query .= ' ORDER BY SecCode';

      $result = $this->connection->query($query);

      $sec_codes = [];

      for($i=0;$i<$result->num_rows;$i++){
         array_push($sec_codes, $result->fetch_array()[0]);
      }

      return $sec_codes;
   }
   public function getSecuritiesByNotClassCodes($class_codes){
      $query = 'SELECT DISTINCT SecCode FROM Securities WHERE';
      if(count($class_codes) == 1){
         $query .=  ' NOT ClassCode="' . $class_codes[0] . '"';
      }else{
         for($i=0;$i<count($class_codes);$i++){
            if($i == 0){
               $query .= ' NOT ClassCode="' . $class_codes[$i] . '"';
            }else{
               $query .= ' AND NOT ClassCode="' . $class_codes[$i] . '"';
            }            
         }
      }
      $query .= ' ORDER BY SecCode';

      $result = $this->connection->query($query);

      $sec_codes = [];

      for($i=0;$i<$result->num_rows;$i++){
         array_push($sec_codes, $result->fetch_array()[0]);
      }

      return $sec_codes;
   }
   public function updateSecurity($security){
      $security_id = $this->getSecurityId($security->ClassCode, $security->SecCode);
      if($security_id == null){
         $this->addSecurity($security);
      }else{
         $stmt = $this->connection
         ->prepare("UPDATE Securities SET
            Timestamp=?, 
            ClassCode=?, 
            SecCode=?, 
            SecTypeStatic=?, 
            SecSubtypeStatic=?, 
            SecName=?, 
            ShortName=?, 
            ISIN=?, 
            RegNumber=?, 
            ClassName=?, 
            FaceValue=?, 
            FaceUnit=?, 
            Scale=?, 
            MinPriceStep=?, 
            SecStatus=?, 
            LotSize=?, 
            IssueSize=?, 
            QuoteBasis=?, 
            SettleCode=?, 
            CurrencyId=? WHERE Id=?"
         );
         $stmt->bind_param("ssssssssssdsidsiisssi", 
            $security->Timestamp, 
            $security->ClassCode, 
            $security->SecCode, 
            $security->SecTypeStatic, 
            $security->SecSubtypeStatic, 
            $security->SecName, 
            $security->ShortName, 
            $security->ISIN, 
            $security->RegNumber, 
            $security->ClassName, 
            $security->FaceValue, 
            $security->FaceUnit, 
            $security->Scale, 
            $security->MinPriceStep, 
            $security->SecStatus, 
            $security->LotSize, 
            $security->IssueSize, 
            $security->QuoteBasis, 
            $security->SettleCode, 
            $security->CurrencyId, 
            $security_id
         );
         $stmt->execute();
      }
   }
   public function getSecurityQty(){
      $query = 'SELECT * FROM Securities';
      $result = $this->connection->query($query);
      return $result->num_rows;
   }
   public function getSecurityPart($part = null, $qty = null){
      $security = [];

      $query = '';

      $rows_qty = $this->getSecurityQty();

      if($part != null && $qty != null){
         $from = $rows_qty - $qty * $part;
         if($from < 0){
            $qty = $qty + $from;
            $from = 0;
         }
         $query = 'SELECT * FROM Securities ORDER BY Id LIMIT ' . $from . ', ' . $qty;
      }else{
         $query = 'SELECT * FROM Securities';
      }

      $result = $this->connection->query($query);
      if ($result->num_rows > 0){
         while ($_security = $result->fetch_object('Security')){
            array_push($security, $_security);
         }    
      }else{
         return null;
      }

      return $security;
   }
   public function getSecurityClassCode($sec_code, $good_class_codes){
      $query = 'SELECT ClassCode FROM Securities WHERE';
      if(count($good_class_codes) == 1){
         $query .=  ' SecCode="' . $sec_code . '" AND ClassCode="' . $good_class_codes[0] . '" LIMIT 1';
      }else{
         $query .=  ' SecCode="' . $sec_code . '" AND (';
         for($i=0;$i<count($good_class_codes);$i++){
            if($i == 0){
               $query .= ' ClassCode="' . $good_class_codes[$i] . '"';
            }else{
               $query .= ' OR ClassCode="' . $good_class_codes[$i] . '"';
            }            
         }
         $query .=  ') LIMIT 1';
      }
      $result = $this->connection->query($query);

      return $result->fetch_array()[0];
   }

   public function addSecurityCurrentParams($security_current_params){
      $security_id = $this->getSecurityId($security_current_params->ClassCode, $security_current_params->SecCode);
      if($security_id == null) return;

      $stmt = $this->connection
         ->prepare("INSERT INTO SecuritiesCurrentParams(
            Timestamp, 
            SecurityId, 
            PrevValtoday, 
            PrevSettlePrice, 
            Last) 
         VALUES (?,?,?,?,?)");
      
      $stmt->bind_param("siddd", 
         $security_current_params->Timestamp, 
         $security_id, 
         $security_current_params->PrevValtoday, 
         $security_current_params->PrevSettlePrice, 
         $security_current_params->Last
      );
      $stmt->execute();
   }
   public function getSecurityCurrentParams($class_code, $sec_code){
      $security_id = $this->getSecurityId($class_code, $sec_code);
      if($security_id == null) return;
      $stmt = $this->connection->prepare('SELECT * FROM SecuritiesCurrentParams WHERE SecurityId=? ORDER BY Id DESC LIMIT 1');
      $stmt->bind_param("i", $security_id);
      $stmt->execute();
      $result = $stmt->get_result();
      if ($result->num_rows > 0){
         return $result->fetch_object('SecurityCurrentParams');
      }else{
         return null;
      }
   }

   // $month формат '2024-09'
   public function getTrades($month = null){
      $trades = [];

      $query = '';
      if($month == null)
         $query = 'SELECT * FROM Sdelki';
      else
         $query = 'SELECT * FROM Sdelki WHERE (Data LIKE "' . $month . '%")';

      $result = $this->connection->query($query);
      if ($result->num_rows > 0){
         while ($trade = $result->fetch_object('Trade')){
            array_push($trades, $trade);
         }    
      }else{
         return null;
      }

      return $trades;
   }
}